/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.integration.crafttweaker.spell;

import com.windanesz.wizardryutils.spell.SpellDynamicMinion;
import crafttweaker.annotations.ZenRegister;
import electroblob.wizardry.spell.Spell;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.world.World;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.wizardryutils.MinionSpells")
@ZenRegister
public class ZenMinionSpell {
    public static final List<MinionSpellEntry> entries = new ArrayList<MinionSpellEntry>();

    @ZenMethod
    public static void create(String name, String entityClassName) {
        entries.add(new MinionSpellEntry(name, entityClassName));
    }

    public static Spell instantiate(MinionSpellEntry entry) {
        if (entry == null) {
            throw new RuntimeException("MinionSpellEntry cannot be null!");
        }
        String name = entry.name;
        String entityClassName = entry.entityClassName;
        try {
            Class<?> entityClass = Class.forName(entityClassName);
            if (!Entity.class.isAssignableFrom(entityClass)) {
                throw new RuntimeException("Class " + entityClassName + " is not an Entity!");
            }
            if (!EntityCreature.class.isAssignableFrom(entityClass)) {
                throw new RuntimeException("Class " + entityClassName + " does not extend EntityCreature!");
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find minion entity class " + entityClassName + "!", e);
        }
        SpellDynamicMinion<EntityCreature> spell = new SpellDynamicMinion<EntityCreature>("contenttweaker", name, world -> {
            try {
                Class<?> entityClass = Class.forName(entityClassName);
                Constructor<?> constructor = entityClass.getConstructor(World.class);
                EntityCreature entity = (EntityCreature)constructor.newInstance(world);
                for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                    entity.func_184642_a(slot, 0.0f);
                }
                if (entity != null) {
                    return entity;
                }
                throw new RuntimeException("Entity " + entityClassName + " is not a valid minion entity!");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate minion entity " + entityClassName + "!", e);
            }
        });
        return spell;
    }

    public static final class MinionSpellEntry {
        public final String name;
        public final String entityClassName;

        public MinionSpellEntry(String name, String entityClassName) {
            this.name = name;
            this.entityClassName = entityClassName;
        }
    }
}

