/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.integration.crafttweaker.spell;

import crafttweaker.annotations.ZenRegister;
import electroblob.wizardry.spell.Spell;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.wizardryutils.ZenSpell")
@ZenRegister
public class ZenSpell {
    private final Spell spell;

    public ZenSpell(Spell spell) {
        this.spell = spell;
    }

    @ZenMethod
    public static ZenSpell byMetadata(int metadata) {
        return new ZenSpell(Spell.byMetadata((int)metadata));
    }

    @ZenMethod
    public static ZenSpell getSpell(String name) {
        return new ZenSpell(Spell.get((String)name));
    }

    @ZenMethod
    public static int getMetaData(String spell) {
        return Spell.get((String)spell).metadata();
    }

    @ZenGetter(value="elementID")
    @ZenMethod
    public int getElementID() {
        return this.spell.getElement().ordinal();
    }

    @ZenGetter(value="element")
    public String getGetElement() {
        return this.spell.getElement().name().toUpperCase();
    }

    @ZenMethod
    public boolean hasProperty(String identifier) {
        return this.spell.hasProperty(identifier);
    }

    @ZenMethod
    public float getProperty(String identifier) {
        return this.spell.getProperty(identifier).floatValue();
    }

    @ZenGetter(value="networkID")
    @ZenMethod
    public int getNetworkID() {
        return this.spell.networkID();
    }

    @ZenGetter(value="name")
    @ZenMethod
    public String getName() {
        return this.spell.getRegistryName().toString();
    }

    @ZenGetter(value="tierID")
    @ZenMethod
    public int getTierID() {
        return this.spell.getTier().ordinal();
    }

    @ZenGetter(value="tier")
    @ZenMethod
    public String getTier() {
        return this.spell.getTier().name().toUpperCase();
    }

    @ZenGetter(value="typeID")
    @ZenMethod
    public int getTypeID() {
        return this.spell.getType().ordinal();
    }

    @ZenGetter(value="type")
    @ZenMethod
    public String getType() {
        return this.spell.getType().name().toUpperCase();
    }

    @ZenGetter(value="cost")
    @ZenMethod
    public int getCost() {
        return this.spell.getCost();
    }

    @ZenGetter(value="cooldown")
    @ZenMethod
    public int getCooldown() {
        return this.spell.getCooldown();
    }

    @ZenGetter(value="displayName")
    @ZenMethod
    public String getDisplayName() {
        return this.spell.getDisplayName();
    }
}

