/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.integration.crafttweaker.spell;

import com.windanesz.wizardryutils.spell.SpellIProjectile;
import crafttweaker.annotations.ZenRegister;
import electroblob.wizardry.spell.Spell;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.world.World;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.wizardryutils.ProjectileSpells")
@ZenRegister
public class ZenSpellProjectile {
    public static final List<ProjectileSpellEntry> entries = new ArrayList<ProjectileSpellEntry>();

    @ZenMethod
    public static void create(String name, String entityClassName) {
        entries.add(new ProjectileSpellEntry(name, entityClassName));
    }

    public static Spell instantiate(ProjectileSpellEntry entry) {
        if (entry == null) {
            throw new RuntimeException("ProjectileSpellEntry cannot be null!");
        }
        String name = entry.name;
        String entityClassName = entry.entityClassName;
        try {
            Class<?> entityClass = Class.forName(entityClassName);
            if (!Entity.class.isAssignableFrom(entityClass)) {
                throw new RuntimeException("Class " + entityClassName + " is not an Entity!");
            }
            if (!IProjectile.class.isAssignableFrom(entityClass)) {
                throw new RuntimeException("Class " + entityClassName + " does not implement IProjectile!");
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find projectile class " + entityClassName + "!", e);
        }
        SpellIProjectile<Entity> spell = new SpellIProjectile<Entity>("contenttweaker", name, world -> {
            try {
                Class<?> entityClass = Class.forName(entityClassName);
                Constructor<?> constructor = entityClass.getConstructor(World.class);
                Entity entity = (Entity)constructor.newInstance(world);
                if (entity instanceof IProjectile) {
                    Entity projectile = entity;
                    return (Entity)((IProjectile)projectile);
                }
                throw new RuntimeException("Entity " + entityClassName + " is not a valid projectile entity (must implement IProjectile)!");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate projectile entity " + entityClassName + "!", e);
            }
        });
        return spell;
    }

    public static final class ProjectileSpellEntry {
        public final String name;
        public final String entityClassName;

        public ProjectileSpellEntry(String name, String entityClassName) {
            this.name = name;
            this.entityClassName = entityClassName;
        }
    }
}

