/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.item;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellProperties;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemDustySpellBook
extends Item {
    public ItemDustySpellBook() {
        this.func_77625_d(1);
        this.func_77637_a(WizardryTabs.WIZARDRY);
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(Wizardry.proxy.translate("item." + this.getRegistryName().toString() + ".desc", new Object[0]));
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (!world.field_72995_K) {
            List bookTypeList = ForgeRegistries.ITEMS.getValuesCollection().stream().filter(i -> i instanceof ItemSpellBook).collect(Collectors.toList());
            Spell newSpell = ItemDustySpellBook.getRandomSpell(world);
            for (int i2 = 0; i2 < bookTypeList.size(); ++i2) {
                Item currentBook = (Item)bookTypeList.get(i2);
                if (!newSpell.applicableForItem(currentBook)) continue;
                return new ItemStack(currentBook, 1, newSpell.metadata());
            }
        }
        return super.func_77654_b(stack, world, entityLiving);
    }

    private static Spell getRandomSpell(World world) {
        Tier tier = Tier.getWeightedRandomTier((Random)world.field_73012_v, (Tier[])new Tier[]{Tier.NOVICE, Tier.APPRENTICE, Tier.ADVANCED, Tier.MASTER});
        List spells = Spell.getSpells((Predicate)new Spell.TierElementFilter(null, null, new SpellProperties.Context[]{SpellProperties.Context.BOOK}));
        spells.removeIf(new Spell.TierElementFilter(tier, null, new SpellProperties.Context[]{SpellProperties.Context.LOOTING}).negate());
        if (spells.size() != 0) {
            return (Spell)spells.get(field_77697_d.nextInt(spells.size()));
        }
        return Spells.none;
    }
}

