/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.registry;

import com.windanesz.wizardryutils.WizardryUtils;
import electroblob.wizardry.item.IMultiTexturedItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class ItemModelRegistry {
    private static List<String> ADDON_MODID_REGISTRY = new ArrayList<String>();

    private ItemModelRegistry() {
    }

    public static void registerModForAutoItemModelRegistry(String modid) {
        if (!ADDON_MODID_REGISTRY.contains(modid)) {
            WizardryUtils.logger.info("Registered modid " + modid + " for automatic item model registry");
            ADDON_MODID_REGISTRY.add(modid);
        }
    }

    @SubscribeEvent
    public static void register(ModelRegistryEvent event) {
        for (Item item : Item.field_150901_e) {
            if (!ADDON_MODID_REGISTRY.contains(item.getRegistryName().func_110624_b())) continue;
            ItemModelRegistry.registerItemModel(item);
        }
    }

    public static void registerItemModel(Item item) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(item.getRegistryName(), "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)item, s -> new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    private static <T extends Item> void registerMultiTexturedModel(T item) {
        if (item.func_77614_k()) {
            NonNullList items = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), items);
            for (ItemStack stack : items) {
                ModelLoader.setCustomModelResourceLocation(item, (int)stack.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(((IMultiTexturedItem)item).getModelName(stack), "inventory"));
            }
        }
    }

    private static void registerItemModel(Item item, int metadata, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
    }
}

