/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.registry;

import com.windanesz.wizardryutils.Settings;
import com.windanesz.wizardryutils.WizardryUtils;
import com.windanesz.wizardryutils.loot.ArtefactCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class LootRegistry {
    private static List<Item> artefacts = new ArrayList<Item>();

    private LootRegistry() {
    }

    public static void addArtefact(Item artefact) {
        artefacts.add(artefact);
    }

    public static void preInit() {
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ArtefactCondition.Serializer());
    }

    @SubscribeEvent
    public static void onLootTableLoadEvent(LootTableLoadEvent event) {
        Pattern p;
        Matcher m;
        if (Settings.generalSettings.auto_inject_artefacts_to_shrines && event.getName().func_110624_b().equals("ebwizardry") && (m = (p = Pattern.compile(".*subsets/(.*)_artefacts")).matcher(event.getName().func_110623_a())).find()) {
            String poolName = m.group(1) + "_artefacts";
            EnumRarity rarity = EnumRarity.valueOf((String)m.group(1).toUpperCase());
            ArrayList<Item> inject = new ArrayList<Item>();
            for (Item artefact : artefacts) {
                if (artefact.getForgeRarity(new ItemStack(artefact)) != rarity) continue;
                inject.add(artefact);
            }
            if (!inject.isEmpty()) {
                int index = 0;
                for (Item item : inject) {
                    WizardryUtils.logger.debug("Injecting loot entry item " + item.getRegistryName().toString() + " to " + poolName + " Wizardry loot table.");
                    event.getTable().getPool(poolName).addEntry((LootEntry)new LootEntryItem(item, 1, 0, new LootFunction[0], new LootCondition[0], item.getRegistryName().func_110623_a() + "_" + index));
                }
            }
        }
    }

    private static void injectEntries(LootPool sourcePool, LootPool targetPool) {
        if (sourcePool != null && targetPool != null) {
            List lootEntries = (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)sourcePool, (String)"field_186453_a");
            for (LootEntry entry : lootEntries) {
                targetPool.addEntry(entry);
            }
        } else {
            WizardryUtils.logger.warn("Attempted to inject to null pool source or target.");
        }
    }

    private static LootPool getAdditive(String entryName, String poolName) {
        return new LootPool(new LootEntry[]{LootRegistry.getAdditiveEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "wizardryutils_" + poolName);
    }

    private static LootEntryTable getAdditiveEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation(name), weight, 0, new LootCondition[0], "wizardryutils_additive_entry");
    }
}

