/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.spell;

import com.windanesz.wizardryutils.entity.EntityDynamicConstruct;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SpellDynamicAreaEffect
extends Spell {
    public static final String EFFECT_RADIUS = "effect_radius";
    public static final String EFFECT_DURATION = "effect_duration";
    public static final String CONSTRUCT_LIFETIME = "lifetime";
    public static final String CREATURE_TARGETING = "creature_targeting";
    private final Supplier<Potion>[] potionSuppliers;
    private final float r;
    private final float g;
    private final float b;

    public SpellDynamicAreaEffect(String modID, String name, float r, float g, float b, Supplier<Potion>[] potionSuppliers) {
        super(modID, name, SpellActions.POINT, false);
        this.r = r;
        this.g = g;
        this.b = b;
        this.potionSuppliers = potionSuppliers;
        this.addProperties(new String[]{EFFECT_RADIUS, EFFECT_DURATION, CONSTRUCT_LIFETIME, CREATURE_TARGETING});
        this.npcSelector((e, o) -> true);
    }

    public boolean requiresPacket() {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        double distance = 5.0 * (double)modifiers.get(WizardryItems.range_upgrade);
        double x = caster.field_70165_t + look.field_72450_a * distance;
        double y = caster.field_70163_u + (double)caster.func_70047_e() + look.field_72448_b * distance;
        double z = caster.field_70161_v + look.field_72449_c * distance;
        if (!world.field_72995_K) {
            this.spawnConstruct(world, x, y, z, (EntityLivingBase)caster, modifiers);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                this.spawnConstruct(world, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v, (EntityLivingBase)caster, modifiers);
            }
        } else {
            Vec3d look = caster.func_70040_Z();
            double distance = 5.0 * (double)modifiers.get(WizardryItems.range_upgrade);
            double x = caster.field_70165_t + look.field_72450_a * distance;
            double y = caster.field_70163_u + (double)caster.func_70047_e() + look.field_72448_b * distance;
            double z = caster.field_70161_v + look.field_72449_c * distance;
            if (!world.field_72995_K) {
                this.spawnConstruct(world, x, y, z, (EntityLivingBase)caster, modifiers);
            }
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            this.spawnConstruct(world, x, y, z, null, modifiers);
        }
        this.playSound(world, x - (double)direction.func_82601_c(), y - (double)direction.func_96559_d(), z - (double)direction.func_82599_e(), ticksInUse, duration, modifiers, new String[0]);
        return true;
    }

    private void spawnConstruct(World world, double x, double y, double z, EntityLivingBase caster, SpellModifiers modifiers) {
        int lifetime = (int)(this.getProperty(CONSTRUCT_LIFETIME).floatValue() * modifiers.get(WizardryItems.duration_upgrade));
        double radius = this.getProperty(EFFECT_RADIUS).doubleValue();
        int creatureTargeting = this.getProperty(CREATURE_TARGETING).intValue();
        EntityDynamicConstruct construct = new EntityDynamicConstruct(world, x, y, z, caster, lifetime, this.r, this.g, this.b, this.potionSuppliers, radius);
        construct.setModifiers(modifiers);
        construct.setCreatureTargeting(creatureTargeting);
        world.func_72838_d((Entity)construct);
    }
}

