/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.spell;

import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumAction;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class SpellIProjectile<T extends Entity>
extends Spell {
    private static final float DISPENSER_INACCURACY = 1.0f;
    private static final float FALLBACK_VELOCITY = 1.5f;
    protected final Function<World, T> projectileFactory;

    public SpellIProjectile(String name, Function<World, T> projectileFactory) {
        this("wizardryutils", name, projectileFactory);
    }

    public SpellIProjectile(String modID, String name, Function<World, T> projectileFactory) {
        super(modID, name, EnumAction.NONE, false);
        this.projectileFactory = projectileFactory;
        this.npcSelector((e, o) -> true);
        this.addProperties(new String[]{"range"});
    }

    public boolean requiresPacket() {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    protected float calculateVelocity(T projectile, SpellModifiers modifiers, float launchHeight) {
        float range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        if (projectile.func_189652_ae()) {
            if (((Entity)projectile).field_70173_aa <= 0) {
                return 1.5f;
            }
            return range / (float)((Entity)projectile).field_70173_aa;
        }
        float g = 0.03f;
        return range / MathHelper.func_76129_c((float)(2.0f * launchHeight / g));
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            Entity projectile = (Entity)this.projectileFactory.apply(world);
            if (projectile instanceof EntityArrow) {
                EntityArrow arrow = (EntityArrow)projectile;
                arrow.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                arrow.field_70250_c = caster;
            }
            projectile.func_70107_b(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - 0.1, caster.field_70161_v);
            Vec3d look = caster.func_70040_Z();
            float velocity = this.calculateVelocity(projectile, modifiers, caster.func_70047_e() - 0.1f);
            ((IProjectile)projectile).func_70186_c(look.field_72450_a, look.field_72448_b, look.field_72449_c, velocity, 1.0f);
            this.addProjectileExtras(projectile, (EntityLivingBase)caster, modifiers);
            world.func_72838_d(projectile);
            caster.func_184609_a(hand);
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null && !world.field_72995_K) {
            Entity projectile = (Entity)this.projectileFactory.apply(world);
            if (projectile instanceof EntityArrow) {
                EntityArrow arrow = (EntityArrow)projectile;
                arrow.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                arrow.field_70250_c = caster;
            }
            projectile.func_70107_b(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - 0.1, caster.field_70161_v);
            double dx = target.field_70165_t - caster.field_70165_t;
            double dy = target.field_70163_u + (double)(target.field_70131_O / 2.0f) - (caster.field_70163_u + (double)caster.func_70047_e() - 0.1);
            double dz = target.field_70161_v - caster.field_70161_v;
            float velocity = this.calculateVelocity(projectile, modifiers, caster.func_70047_e() - 0.1f);
            float aimingError = caster instanceof ISpellCaster ? (float)((ISpellCaster)caster).getAimingError(world.func_175659_aa()) : (float)EntityUtils.getDefaultAimingError((EnumDifficulty)world.func_175659_aa());
            ((IProjectile)projectile).func_70186_c(dx, dy, dz, velocity, aimingError);
            this.addProjectileExtras(projectile, (EntityLivingBase)caster, modifiers);
            world.func_72838_d(projectile);
            caster.func_184609_a(hand);
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            Entity projectile = (Entity)this.projectileFactory.apply(world);
            if (projectile instanceof EntityArrow) {
                ((EntityArrow)projectile).field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
            }
            projectile.func_70107_b(x, y, z);
            Vec3i vec = direction.func_176730_m();
            float velocity = this.calculateVelocity(projectile, modifiers, 0.375f);
            ((IProjectile)projectile).func_70186_c((double)vec.func_177958_n(), (double)vec.func_177956_o(), (double)vec.func_177952_p(), velocity, 1.0f);
            this.addProjectileExtras(projectile, null, modifiers);
            world.func_72838_d(projectile);
            this.playSound(world, x - (double)direction.func_82601_c(), y - (double)direction.func_96559_d(), z - (double)direction.func_82599_e(), ticksInUse, duration, modifiers, new String[0]);
            return true;
        }
        return true;
    }

    protected void addProjectileExtras(T projectile, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
    }
}

